/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover;

import com.skyerzz.friendremover.RemoveFriendsCommand;
import com.skyerzz.friendremover.data.HypixelFriend;
import com.skyerzz.friendremover.gui.TestDrawHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="friendremover", version="2.2", acceptedMinecraftVersions="[1.8.9]")
public class FriendRemover {
    public static final String MODID = "friendremover";
    public static final String VERSION = "2.2";
    public static String API_KEY = "";
    public static ArrayList<String> ignore = new ArrayList();
    public static int delay = 250;
    public static int MAX_DELAY = 750;
    public static int MIN_DELAY = 250;
    public static long LAST_COOLDOWN = 0L;
    public static int delayAttempts = 0;
    public static boolean isRunning = false;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("Initializing FriendRemover...");
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new RemoveFriendsCommand());
        TestDrawHelper.init();
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        ChatComponentText txt;
        if (e.type != 0) {
            return;
        }
        String fullMessage = e.message.func_150260_c();
        if (fullMessage.contains("Your new API key is ")) {
            API_KEY = fullMessage.replace("Your new API key is ", "").replace("To generate a new key do /api new", "").replace("\n", "").trim();
            System.out.print("[Friend Remover] FOUNDAPIKEY: " + API_KEY);
            txt = new ChatComponentText("[FriendRemover] Found new APIkey: " + API_KEY);
            txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
        }
        if (isRunning && !fullMessage.contains(":") && (fullMessage.contains("commands too fast") || fullMessage.contains("sending too many commands"))) {
            delay = Math.min(delay + 50, MAX_DELAY);
            txt = new ChatComponentText("[FriendRemover] Noticing command cooldown, adding more delay.. (" + delay + ")");
            txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
            LAST_COOLDOWN = System.currentTimeMillis();
            if (++delayAttempts == 6) {
                txt = new ChatComponentText("[FriendRemover] Too many tries (6), not lowering delay from here on out! (" + delay + ")");
                txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
            }
        }
    }

    public static void removeFriends(final ArrayList<HypixelFriend> friends) {
        isRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Minecraft.func_71410_x().func_147108_a(null);
                ChatComponentText txt = new ChatComponentText("[FriendRemover] Removing " + friends.size() + " friends. This will spam your chat. Please do not use any commands or log out until the mod is done.");
                txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                txt = new ChatComponentText("[FriendRemover] Starting in 30 seconds! The process will take approximately " + (205 * friends.size() / 1000 + 2) + " seconds.");
                txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                txt = new ChatComponentText("[FriendRemover] Removing friends...");
                txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                for (HypixelFriend f : friends) {
                    if (f.shouldBeRemoved()) {
                        System.out.println("[FriendRemover] Removing Friend " + f.getFriendUUID());
                        Minecraft.func_71410_x().field_71439_g.func_71165_d("/f remove " + f.getFriendUUID().toString().replace("-", ""));
                    } else {
                        System.out.println("[FriendRemover] Found a friend that shouldnt be removed?! This should never happen. If it does, tell skyerzz he is dumb. " + f.getFriendUUID());
                    }
                    try {
                        if (delay != MIN_DELAY && delayAttempts < 6 && LAST_COOLDOWN + 20000L < System.currentTimeMillis()) {
                            delay = Math.max(delay - 50, MIN_DELAY);
                            ChatComponentText txt2 = new ChatComponentText("[FriendRemover] Attempting to lower the command delay... (" + delay + ")");
                            txt2.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt2);
                            LAST_COOLDOWN = System.currentTimeMillis();
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                isRunning = false;
                txt = new ChatComponentText("[FriendRemover] Friends have been removed!");
                txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
            }
        }).start();
    }
}

