/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.games.arena;

import java.util.ArrayList;

public enum COMBATUPGRADE {
    DAMAGE("Melee Upgrade", "Melee Damage: %%VALUE%%"),
    HEALTH("Helath Upgrade", "Maximum Health: %%VALUE%%"),
    ENERGY("Energy Upgrade", "Maximum Energy: %%VALUE%%"),
    COOLDOWN("Cooldown Upgrade", "Cooldown Reduction: %%VALUE%%%");

    private String name;
    private String description;
    public static final ArrayList<String> mapping;

    private COMBATUPGRADE(String name, String description) {
        this.name = name;
        this.description = description;
    }

    private static ArrayList<String> initializeMapping() {
        ArrayList<String> list = new ArrayList<String>();
        for (COMBATUPGRADE item : COMBATUPGRADE.values()) {
            list.add(item.name());
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public double getValue(int level) {
        if (level < 0 || level > 9) {
            return -1.0;
        }
        switch (this) {
            case DAMAGE: {
                if (level < 5) {
                    return 10.0 + 0.22 * (double)level;
                }
                if (level < 9) {
                    return 11.11 + 0.22 * (double)(level - 5);
                }
                return 12.0;
            }
            case HEALTH: {
                if (level < 5) {
                    return 2000 + 22 * level;
                }
                if (level < 9) {
                    return 2111 + 22 * (level - 5);
                }
                return 2220.0;
            }
            case ENERGY: {
                if (level < 5) {
                    return 100 + 2 * level;
                }
                if (level < 9) {
                    return 111 + 2 * (level - 5);
                }
                return 120.0;
            }
            case COOLDOWN: {
                if (level < 9) {
                    return 1.11 * (double)level;
                }
                return 10.0;
            }
        }
        return -1.0;
    }

    public String getDescription(int level) {
        return this.description.replace("%%VALUE%%", this.getValue(level) + "");
    }

    public int getCost(int level) {
        if (level < 0 || level > 9) {
            return -1;
        }
        switch (level) {
            case 1: {
                return 880;
            }
            case 2: {
                return 3520;
            }
            case 3: {
                return 7920;
            }
            case 4: {
                return 14080;
            }
            case 5: {
                return 22000;
            }
            case 6: {
                return 31680;
            }
            case 7: {
                return 43120;
            }
            case 8: {
                return 56320;
            }
            case 9: {
                return 71280;
            }
        }
        return -1;
    }

    static {
        mapping = COMBATUPGRADE.initializeMapping();
    }
}

