/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.games.skywars;

import com.skyerzz.hypixellib.util.CURRENCY;
import com.skyerzz.hypixellib.util.games.skywars.RARITY;
import java.util.ArrayList;

public enum MEGA_PERK {
    ARROW_RECOVERY("Arrow Recovery", RARITY.RARE, 5),
    BLAZING_ARROWS("Blazing Arrows", RARITY.RARE, 5),
    ENDER_MASTERY("Ender Mastery", RARITY.COMMON, 5),
    JUGGERNAUT("Juggernaut", RARITY.RARE, 5),
    MINING_EXPERTISE("Mining Expertise", RARITY.COMMON, 5),
    RUSHER("Rusher", RARITY.COMMON, 5),
    TANK("Tank", RARITY.LEGENDARY, 5),
    NOTORIETY("Notoriety", RARITY.LEGENDARY, 5),
    NOURISHMENT("Nourishment", RARITY.COMMON, 1),
    INSTANT_SMELTING("Instant Smelting", RARITY.COMMON, 1),
    MARKSMANSHIP("Marksmanship", RARITY.LEGENDARY, 1),
    BRIDGER("Bridger", RARITY.COMMON, 5),
    ENVIRONMENTAL_EXPERT("Environmental Expert", RARITY.RARE, 5),
    LUCKY_CHARM("Lucky Charm", RARITY.COMMON, 5);

    private String displayName;
    private RARITY rarity;
    private int maxLevel;
    public static final ArrayList<String> mapping;

    private MEGA_PERK(String displayName, RARITY rarity, int maxLevel) {
        this.displayName = displayName;
        this.rarity = rarity;
        this.maxLevel = maxLevel;
    }

    private static ArrayList<String> initializeMapping() {
        ArrayList<String> list = new ArrayList<String>();
        for (MEGA_PERK item : MEGA_PERK.values()) {
            list.add(item.name());
        }
        return list;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getCost(int level) {
        if (level < 1 || level > this.maxLevel) {
            return -1;
        }
        switch (level) {
            case 1: {
                switch (this.rarity) {
                    case COMMON: {
                        return 5000;
                    }
                    case RARE: {
                        return 50000;
                    }
                    case LEGENDARY: {
                        return 150000;
                    }
                }
            }
            case 2: {
                return 25000;
            }
            case 3: {
                return 75000;
            }
            case 4: {
                return 100000;
            }
            case 5: {
                return 125000;
            }
        }
        return -1;
    }

    public RARITY getRarity() {
        return this.rarity;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public CURRENCY getCurrencyType() {
        return CURRENCY.COINS;
    }

    public String getDescription(int level) {
        if (level < 1 || level > this.maxLevel) {
            return null;
        }
        switch (this) {
            case ARROW_RECOVERY: {
                return "Chance of getting back your arrows on bow hit (" + 5 * level + "%).";
            }
            case BLAZING_ARROWS: {
                return "Chance of shooting a fire arrow with a bow (" + 2 * level + "%).";
            }
            case ENDER_MASTERY: {
                return "Reduces damages taken with enderpearls by " + 20 * level + "%";
            }
            case JUGGERNAUT: {
                return "Enemy kills give you regen II for " + 2 * level + " seconds.";
            }
            case MINING_EXPERTISE: {
                return level * 5 + "% chance to get 1 extra ore per block mined.";
            }
            case RUSHER: {
                return "Gain " + level * 3 + "s of speedI when the game starts.";
            }
            case TANK: {
                return "Enemy kills give you resistance I for " + level * 2 + "s.";
            }
            case NOTORIETY: {
                return "Chance to add one level of sharpness to your sword after every kill with it. (" + level * 2 + "%).";
            }
            case NOURISHMENT: {
                return "Every kill gives you full hunger and saturation.";
            }
            case INSTANT_SMELTING: {
                return "Automatically smelt mined ores into ingots!";
            }
            case MARKSMANSHIP: {
                return "After getting 3 kills with a bow, all your bows get enchanted with power I.";
            }
            case LUCKY_CHARM: {
                return level * 2 + "% Chance to get a Golden Apple on enemy kills.";
            }
            case BRIDGER: {
                return level + "% Chance for placeable blocks to not be consumed upon use.";
            }
            case ENVIRONMENTAL_EXPERT: {
                return "Reduces environmental damage by " + 5 * level + "%";
            }
        }
        return null;
    }

    static {
        mapping = MEGA_PERK.initializeMapping();
    }
}

