/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.util.CHAT;
import com.skyerzz.hypixellib.util.ILevel;
import com.skyerzz.hypixellib.util.RANK;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class PlayerCommonStats
extends PlayerGameStats
implements ILevel {
    private int networkLevel;
    private int karma;
    private int networkEXP;
    private int mostRecentMinecraftVersion;
    private String _id;
    private String displayName;
    private String mostRecentlyThankedName;
    private String mostRecentlyTippedName;
    private UUID mostRecentlyThankedUUID;
    private UUID mostRecentlyTippedUUID;
    private UUID playerUUID;
    private CHAT selectedChannel;
    private RANK rank;
    private RANK newPackageRank;
    private long firstLogin;
    private long lastlogin;
    private boolean mainLobbyTutorialCompleted;
    private boolean clock;

    public PlayerCommonStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.Common.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement value) {
        switch (key) {
            case "NETWORKLEVEL": {
                this.networkLevel = value.getAsInt();
                return true;
            }
            case "_ID": {
                this._id = value.getAsString();
                return true;
            }
            case "DISPLAYNAME": {
                this.displayName = value.getAsString();
                return true;
            }
            case "CLOCK": {
                this.clock = value.getAsBoolean();
                return true;
            }
            case "FIRSTLOGIN": {
                this.firstLogin = value.getAsLong();
                return true;
            }
            case "KARMA": {
                this.karma = value.getAsInt();
                return true;
            }
            case "LASTLOGIN": {
                this.lastlogin = value.getAsLong();
                return true;
            }
            case "MAINLOBBYTUTORIAL": {
                this.mainLobbyTutorialCompleted = value.getAsBoolean();
                return true;
            }
            case "MOSTRECENTMINECRAFTVERSION": {
                this.mostRecentMinecraftVersion = value.getAsInt();
                return true;
            }
            case "MOSTRECENTLYTHANKED": {
                this.mostRecentlyThankedName = value.getAsString();
                return true;
            }
            case "MOSTRECENTLYTIPPED": {
                this.mostRecentlyTippedName = value.getAsString();
                return true;
            }
            case "MOSTRECENTLYTHANKEDUUID": {
                this.mostRecentlyThankedUUID = this.parseUUID(value.getAsString());
                return true;
            }
            case "MOSTRECENTLYTIPPEDUUID": {
                this.mostRecentlyTippedUUID = this.parseUUID(value.getAsString());
                return true;
            }
            case "NETWORKEXP": {
                this.networkEXP = value.getAsInt();
                return true;
            }
            case "UUID": {
                this.playerUUID = this.parseUUID(value.getAsString());
                return true;
            }
        }
        return false;
    }

    private UUID parseUUID(String uuid) {
        if (uuid.contains("-")) {
            return UUID.fromString(uuid);
        }
        String newUUID = uuid.substring(0, 7) + "-" + uuid.substring(8, 11) + "-" + uuid.substring(12, 15) + "-" + uuid.substring(16, 19) + "-" + uuid.substring(20);
        return UUID.fromString(newUUID);
    }

    private boolean setSpecialValue(String key, JsonElement value) {
        switch (key) {
            case "ACHIEVEMENTS": {
                return true;
            }
            case "ACHIEVEMENTSONETIME": {
                return true;
            }
            case "FRIENDREQUESTS": {
                return true;
            }
            case "FRIENDREQUESTSUUID": {
                return true;
            }
            case "KNOWNALIASES": {
                return true;
            }
            case "KNOWNALIASESLOWER": {
                return true;
            }
            case "PARKOURCOMPLETIONS": {
                return true;
            }
            case "QUESTS": {
                return true;
            }
            case "STATS": {
                return true;
            }
            case "CHANNEL": {
                String channel = value.getAsString().toUpperCase();
                if (CHAT.mapping.contains(channel)) {
                    this.selectedChannel = CHAT.valueOf(channel);
                } else {
                    Logger.logWarn("[HypixelAPI.common.channel] Unknown CHANNEL: " + value.getAsString());
                }
                return true;
            }
            case "NEWPACKAGERANK": {
                String newpackagerank = value.getAsString().toUpperCase();
                if (RANK.mapping.contains(newpackagerank)) {
                    this.newPackageRank = RANK.valueOf(newpackagerank);
                } else {
                    Logger.logWarn("[HypixelAPI.common.newPackageRank] Unknown RANK: " + value.getAsString());
                }
                return true;
            }
            case "RANK": {
                String rank = value.getAsString().toUpperCase();
                if (RANK.mapping.contains(rank)) {
                    this.rank = RANK.valueOf(rank);
                } else {
                    Logger.logWarn("[HypixelAPI.common.rank] Unknown RANK: " + value.getAsString());
                }
                return true;
            }
        }
        return false;
    }

    public double getNetworkLevel() {
        return ILevel.getLevel((double)this.getNetworkLevelExperience() + ILevel.getTotalExpToLevel(this.getLastNetworkLevel())) + 1.0;
    }

    public int getLastNetworkLevel() {
        return this.networkLevel;
    }

    public RANK getRank() {
        return this.rank != null ? this.rank : (this.newPackageRank != null ? this.newPackageRank : RANK.NONE);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Date getLastLoginDate() {
        return new Date(this.lastlogin);
    }

    public int getNetworkLevelExperience() {
        return this.networkEXP;
    }
}

