/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.quake.BARREL;
import com.skyerzz.hypixellib.util.games.quake.CASE;
import com.skyerzz.hypixellib.util.games.quake.Gun;
import com.skyerzz.hypixellib.util.games.quake.HAT;
import com.skyerzz.hypixellib.util.games.quake.KILLSOUND;
import com.skyerzz.hypixellib.util.games.quake.KIT;
import com.skyerzz.hypixellib.util.games.quake.MUZZLE;
import com.skyerzz.hypixellib.util.games.quake.SIGHT;
import com.skyerzz.hypixellib.util.games.quake.TRIGGER;
import com.skyerzz.hypixellib.util.games.quake.TRINKET;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.ArrayList;
import java.util.Map;

public class PlayerQuakeStats
extends PlayerGameStats {
    private int coins;
    private int soloDeaths;
    private int soloKills;
    private int soloKillstreaks;
    private int soloWins;
    private int teamDeaths;
    private int teamKills;
    private int teamKillstreaks;
    private int teamWins;
    private boolean instantRespawn;
    private Gun selectedGun;
    private BARREL selectedBarrel;
    private CASE selectedCase;
    private KILLSOUND selectedKillSound;
    private MUZZLE selectedMuzzle;
    private SIGHT selectedSight;
    private TRIGGER selectedTrigger;
    private KIT selectedKit;
    private HAT selectedHat;
    private ArrayList<BARREL> unlockedBarrels = new ArrayList();
    private ArrayList<CASE> unlockedCases = new ArrayList();
    private ArrayList<KILLSOUND> unlockedKillSounds = new ArrayList();
    private ArrayList<MUZZLE> unlockedMuzzles = new ArrayList();
    private ArrayList<SIGHT> unlockedSights = new ArrayList();
    private ArrayList<TRIGGER> unlockedTriggers = new ArrayList();
    private ArrayList<KIT> unlockedKits = new ArrayList();
    private ArrayList<HAT> unlockedHats = new ArrayList();
    private ArrayList<TRINKET> unlockedTrinkets = new ArrayList();
    @OutDated
    private boolean achievement_flag_1;
    @OutDated
    private boolean achievement_flag_3;
    @OutDated
    private int dailyKills;
    @OutDated
    private int weeklyKills;
    @OutDated
    private int weekly_kills_a;
    @OutDated
    private int monthly_kills_a;
    @OutDated
    private int weekly_kills_b;
    @OutDated
    private int monthly_kills_b;
    @OutDated
    private int wins_DM;
    @OutDated
    private int wins_timeAttack;
    @OutDated
    private int wins_dmTeam;
    @OutDated
    private int wins_team;
    @OutDated
    private int team_wins;

    public PlayerQuakeStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.Quake.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement value) {
        if (value.isJsonNull()) {
            Logger.logInfo("[PlayerAPI.Quake.initialize] Found JsonNull for key:" + key);
            return true;
        }
        switch (key) {
            case "COINS": {
                this.coins = value.getAsInt();
                break;
            }
            case "DEATHS": {
                this.soloDeaths = value.getAsInt();
                break;
            }
            case "KILLS": {
                this.soloKills = value.getAsInt();
                break;
            }
            case "KILLSTREAKS": {
                this.soloKillstreaks = value.getAsInt();
                break;
            }
            case "WINS": {
                this.soloWins = value.getAsInt();
                break;
            }
            case "KILLS_TEAMS": {
                this.teamKills = value.getAsInt();
                break;
            }
            case "DEATHS_TEAMS": {
                this.teamDeaths = value.getAsInt();
                break;
            }
            case "WINS_TEAMS": {
                this.teamWins = value.getAsInt();
                break;
            }
            case "KILLSTREAKS_TEAMS": {
                this.teamKillstreaks = value.getAsInt();
                break;
            }
            case "MONTHLY_KILLS_B": {
                this.monthly_kills_b = value.getAsInt();
                break;
            }
            case "MONTHLY_KILLS_A": {
                this.monthly_kills_a = value.getAsInt();
                break;
            }
            case "WEEKLY_KILLS_A": {
                this.weekly_kills_a = value.getAsInt();
                break;
            }
            case "WEEKLY_KILLS_B": {
                this.weekly_kills_b = value.getAsInt();
                break;
            }
            case "INSTANTRESPAWN": {
                this.instantRespawn = value.getAsBoolean();
                return true;
            }
            case "TEAM_WINS": {
                this.team_wins = value.getAsInt();
                return true;
            }
            case "WINS_TEAM": {
                this.wins_team = value.getAsInt();
                return true;
            }
            case "WINS_DM": {
                this.wins_DM = value.getAsInt();
                return true;
            }
            case "WINS_TIMEATTACK": {
                this.wins_timeAttack = value.getAsInt();
                return true;
            }
            case "WINS_DM_TEAM": {
                this.wins_dmTeam = value.getAsInt();
                return true;
            }
            case "DAILY_KILLS": {
                this.dailyKills = value.getAsInt();
                return true;
            }
            case "WEEKLY_KILLS": {
                this.weeklyKills = value.getAsInt();
                return true;
            }
            case "BARREL": {
                if (BARREL.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedBarrel = BARREL.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Barrel] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "CASE": {
                if (CASE.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedCase = CASE.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Case] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "KILLSOUND": {
                if (KILLSOUND.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedKillSound = KILLSOUND.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.KillSound] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "MUZZLE": {
                if (MUZZLE.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedMuzzle = MUZZLE.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Muzzle] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "SIGHT": {
                if (SIGHT.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedSight = SIGHT.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Sight] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "TRIGGER": {
                if (TRIGGER.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedTrigger = TRIGGER.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Trigger] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "HAT": {
                if (HAT.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedHat = HAT.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Hat] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "ARMOR": {
                if (KIT.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedKit = KIT.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[PlayerAPI.Quake.Kit] Unknown Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "NULL": {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean setSpecialValue(String key, JsonElement value) {
        switch (key) {
            case "PACKAGES": {
                this.setPackageValues(value.getAsJsonArray());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setPackageValues(JsonArray array) {
        for (JsonElement value : array) {
            String name = value.getAsString().toUpperCase();
            if ((name = name.replaceAll("[A-Z]+\\.", "")).equals("INSTANT_RESPAWN")) {
                this.instantRespawn = true;
                continue;
            }
            if (name.equals("ACHIEVEMENT_FLAG_1") || name.equals("FLAG_1")) {
                this.achievement_flag_1 = true;
                continue;
            }
            if (name.equals("ACHIEVEMENT_FLAG_3")) {
                this.achievement_flag_3 = true;
                continue;
            }
            if (KILLSOUND.mapping.contains(name)) {
                this.unlockedKillSounds.add(KILLSOUND.valueOf(name));
                continue;
            }
            if (KIT.mapping.contains(name)) {
                this.unlockedKits.add(KIT.valueOf(name));
                continue;
            }
            if (HAT.mapping.contains(name)) {
                this.unlockedHats.add(HAT.valueOf(name));
                continue;
            }
            if (BARREL.mapping.contains(name)) {
                this.unlockedBarrels.add(BARREL.valueOf(name));
                continue;
            }
            if (CASE.mapping.contains(name)) {
                this.unlockedCases.add(CASE.valueOf(name));
                continue;
            }
            if (MUZZLE.mapping.contains(name)) {
                this.unlockedMuzzles.add(MUZZLE.valueOf(name));
                continue;
            }
            if (SIGHT.mapping.contains(name)) {
                this.unlockedSights.add(SIGHT.valueOf(name));
                continue;
            }
            if (TRIGGER.mapping.contains(name)) {
                this.unlockedTriggers.add(TRIGGER.valueOf(name));
                continue;
            }
            if (TRINKET.mapping.contains(name)) {
                this.unlockedTrinkets.add(TRINKET.valueOf(name));
                continue;
            }
            Logger.logWarn("[PlayerAPI.Quake.packages] Unknown Value: " + value.getAsString().toUpperCase());
        }
    }

    public int getCoins() {
        return this.coins;
    }

    public int getSoloDeaths() {
        return this.soloDeaths;
    }

    public int getSoloKills() {
        return this.soloKills;
    }

    public int getSoloKillstreaks() {
        return this.soloKillstreaks;
    }

    public int getSoloWins() {
        return this.soloWins;
    }

    public int getTeamDeaths() {
        return this.teamDeaths;
    }

    public int getTeamKills() {
        return this.teamKills;
    }

    public int getTeamKillstreaks() {
        return this.teamKillstreaks;
    }

    public int getTeamWins() {
        return this.teamWins;
    }

    @OutDated
    public int getWeekly_kills_a() {
        return this.weekly_kills_a;
    }

    @OutDated
    public int getMonthly_kills_a() {
        return this.monthly_kills_a;
    }

    @OutDated
    public int getWeekly_kills_b() {
        return this.weekly_kills_b;
    }

    @OutDated
    public int getMonthly_kills_b() {
        return this.monthly_kills_b;
    }

    public boolean isInstantRespawn() {
        return this.instantRespawn;
    }

    public KILLSOUND getSelectedKillSound() {
        return this.selectedKillSound;
    }

    public KIT getSelectedKit() {
        return this.selectedKit;
    }

    public HAT getSelectedHat() {
        return this.selectedHat;
    }

    public Gun getSelectedGun() {
        if (this.selectedGun == null) {
            this.selectedGun = new Gun(this.selectedBarrel, this.selectedCase, this.selectedMuzzle, this.selectedSight, this.selectedTrigger);
        }
        return this.selectedGun;
    }

    public ArrayList<BARREL> getUnlockedBarrels() {
        return this.unlockedBarrels;
    }

    public ArrayList<CASE> getUnlockedCases() {
        return this.unlockedCases;
    }

    public ArrayList<KILLSOUND> getUnlockedKillSounds() {
        return this.unlockedKillSounds;
    }

    public ArrayList<MUZZLE> getUnlockedMuzzles() {
        return this.unlockedMuzzles;
    }

    public ArrayList<SIGHT> getUnlockedSights() {
        return this.unlockedSights;
    }

    public ArrayList<TRIGGER> getUnlockedTriggers() {
        return this.unlockedTriggers;
    }

    public ArrayList<KIT> getUnlockedKits() {
        return this.unlockedKits;
    }

    public ArrayList<HAT> getUnlockedHats() {
        return this.unlockedHats;
    }

    public ArrayList<TRINKET> getUnlockedTrinkets() {
        return this.unlockedTrinkets;
    }

    public BARREL getSelectedBarrel() {
        return this.selectedBarrel;
    }

    public CASE getSelectedCase() {
        return this.selectedCase;
    }

    public MUZZLE getSelectedMuzzle() {
        return this.selectedMuzzle;
    }

    public SIGHT getSelectedSight() {
        return this.selectedSight;
    }

    public TRIGGER getSelectedTrigger() {
        return this.selectedTrigger;
    }

    @OutDated
    public boolean isAchievement_flag_1() {
        return this.achievement_flag_1;
    }

    @OutDated
    public int getDailyKills() {
        return this.dailyKills;
    }

    @OutDated
    public int getWeeklyKills() {
        return this.weeklyKills;
    }

    @OutDated
    public int getWins_DM() {
        return this.wins_DM;
    }

    @OutDated
    public int getWins_timeAttack() {
        return this.wins_timeAttack;
    }

    @OutDated
    public int getWins_dmTeam() {
        return this.wins_dmTeam;
    }

    @OutDated
    public int getWins_team() {
        return this.wins_team;
    }

    @OutDated
    public int getTeam_wins() {
        return this.team_wins;
    }
}

