/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.vampirez.DISGUISE;
import com.skyerzz.hypixellib.util.games.vampirez.HUMANPERK;
import com.skyerzz.hypixellib.util.games.vampirez.VAMPIREPERK;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlayerVampireZStats
extends PlayerGameStats {
    private boolean combatTracker;
    private boolean blood;
    private int coins;
    private int gold_bought;
    private int human_wins;
    private int human_kills;
    private int human_deaths;
    private int zombie_kills;
    private int loot_drops;
    private int vampire_wins;
    private int vampire_deaths;
    private int vampire_kills;
    private int most_vampire_kills;
    @OutDated
    private int monthly_human_wins_b;
    @OutDated
    private int weekly_human_wins_b;
    @OutDated
    private int monthly_human_wins_a;
    @OutDated
    private int weekly_human_wins_a;
    @OutDated
    private int monthly_vampire_wins_b;
    @OutDated
    private int weekly_vampire_wins_b;
    @OutDated
    private int monthly_vampire_wins_a;
    @OutDated
    private int weekly_vampire_wins_a;
    @OutDated
    private int votes_Plundered;
    @OutDated
    private int votes_Church;
    @OutDated
    private int votes_DarkValley;
    @OutDated
    private int votes_Pyramids;
    @OutDated
    private int votes_Overhill;
    @OutDated
    private int votes_Erias;
    private HashMap<HUMANPERK, Integer> humanPerk = new HashMap();
    private HashMap<VAMPIREPERK, Integer> vampirePerk = new HashMap();
    private ArrayList<DISGUISE> unlockedDisguises = new ArrayList();
    private DISGUISE selectedDisguise;

    public PlayerVampireZStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (HUMANPERK.mapping.contains(key)) {
                this.humanPerk.put(HUMANPERK.valueOf(key), ((JsonElement)e.getValue()).getAsInt() + 1);
                continue;
            }
            if (VAMPIREPERK.mapping.contains(key)) {
                this.vampirePerk.put(VAMPIREPERK.valueOf(key), ((JsonElement)e.getValue()).getAsInt() + 1);
                continue;
            }
            if (this.setValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.VampireZ.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String JSONkey, JsonElement value) {
        switch (JSONkey) {
            case "PACKAGES": {
                this.setPackages();
                return true;
            }
            case "DISGUISE": {
                return this.setDisguiseValue(value.getAsString());
            }
            case "COMBATTRACKER": {
                this.combatTracker = value.getAsBoolean();
                return true;
            }
            case "BLOOD": {
                this.blood = value.getAsBoolean();
                return true;
            }
        }
        return this.setStatValue(JSONkey, value);
    }

    private boolean setStatValue(String key, JsonElement value) {
        switch (key.toLowerCase()) {
            case "coins": {
                this.coins = value.getAsInt();
                return true;
            }
            case "gold_bought": {
                this.gold_bought = value.getAsInt();
                return true;
            }
            case "human_deaths": {
                this.human_deaths = value.getAsInt();
                return true;
            }
            case "human_kills": {
                this.human_kills = value.getAsInt();
                return true;
            }
            case "human_wins": {
                this.human_wins = value.getAsInt();
                return true;
            }
            case "zombie_kills": {
                this.zombie_kills = value.getAsInt();
                return true;
            }
            case "most_vampire_kills": {
                this.most_vampire_kills = value.getAsInt();
                return true;
            }
            case "vampire_deaths": {
                this.vampire_deaths = value.getAsInt();
                return true;
            }
            case "vampire_kills": {
                this.vampire_kills = value.getAsInt();
                return true;
            }
            case "vampire_wins": {
                this.vampire_wins = value.getAsInt();
                return true;
            }
            case "loot_drops": {
                this.loot_drops = value.getAsInt();
                return true;
            }
            case "monthly_human_wins_b": {
                this.monthly_human_wins_b = value.getAsInt();
                return true;
            }
            case "monthly_human_wins_a": {
                this.monthly_human_wins_a = value.getAsInt();
                return true;
            }
            case "weekly_human_wins_b": {
                this.weekly_human_wins_b = value.getAsInt();
                return true;
            }
            case "weekly_human_wins_a": {
                this.weekly_human_wins_a = value.getAsInt();
                return true;
            }
            case "monthly_vampire_wins_b": {
                this.monthly_vampire_wins_b = value.getAsInt();
                return true;
            }
            case "monthly_vampire_wins_a": {
                this.monthly_vampire_wins_a = value.getAsInt();
                return true;
            }
            case "weekly_vampire_wins_b": {
                this.weekly_vampire_wins_b = value.getAsInt();
                return true;
            }
            case "weekly_vampire_wins_a": {
                this.weekly_vampire_wins_a = value.getAsInt();
                return true;
            }
            case "votes_plundered": {
                this.votes_Plundered = value.getAsInt();
                return true;
            }
            case "votes_church": {
                this.votes_Church = value.getAsInt();
                return true;
            }
            case "votes_dark valley": {
                this.votes_DarkValley = value.getAsInt();
                return true;
            }
            case "votes_pyramids": {
                this.votes_Pyramids = value.getAsInt();
                return true;
            }
            case "votes_overhill": {
                this.votes_Overhill = value.getAsInt();
                return true;
            }
            case "votes_erias": {
                this.votes_Erias = value.getAsInt();
                return true;
            }
        }
        return false;
    }

    private void setPackages() {
        for (JsonElement s : this.getJsonArray("packages")) {
            String value = s.getAsString().toUpperCase();
            if (DISGUISE.mapping.contains(value)) {
                this.unlockedDisguises.add(DISGUISE.valueOf(value));
                continue;
            }
            Logger.logWarn("[PlayerAPI.VampireZ.package] Unknown value: " + value);
        }
    }

    private boolean setDisguiseValue(String value) {
        switch (value) {
            case "ENDERMAN": {
                this.selectedDisguise = DISGUISE.ATTRACTIVE_ENDERMAN;
                return true;
            }
            case "SKELETON": {
                this.selectedDisguise = DISGUISE.ATTRACTIVE_SKELETON;
                return true;
            }
            case "HEROBRINE": {
                this.selectedDisguise = DISGUISE.ATTRACTIVE;
                return true;
            }
        }
        return false;
    }

    public boolean isCombatTracker() {
        return this.combatTracker;
    }

    public int getCoins() {
        return this.coins;
    }

    public int getGold_bought() {
        return this.gold_bought;
    }

    public int getHuman_wins() {
        return this.human_wins;
    }

    public int getHuman_kills() {
        return this.human_kills;
    }

    public int getHuman_deaths() {
        return this.human_deaths;
    }

    public int getZombie_kills() {
        return this.zombie_kills;
    }

    public int getLoot_drops() {
        return this.loot_drops;
    }

    public int getVampire_wins() {
        return this.vampire_wins;
    }

    public int getVampire_deaths() {
        return this.vampire_deaths;
    }

    public int getVampire_kills() {
        return this.vampire_kills;
    }

    public int getMost_vampire_kills() {
        return this.most_vampire_kills;
    }

    @OutDated
    public int getMonthly_human_wins_b() {
        return this.monthly_human_wins_b;
    }

    @OutDated
    public int getWeekly_human_wins_b() {
        return this.weekly_human_wins_b;
    }

    @OutDated
    public int getMonthly_human_wins_a() {
        return this.monthly_human_wins_a;
    }

    @OutDated
    public int getWeekly_human_wins_a() {
        return this.weekly_human_wins_a;
    }

    @OutDated
    public int getMonthly_vampire_wins_b() {
        return this.monthly_vampire_wins_b;
    }

    @OutDated
    public int getWeekly_vampire_wins_b() {
        return this.weekly_vampire_wins_b;
    }

    @OutDated
    public int getMonthly_vampire_wins_a() {
        return this.monthly_vampire_wins_a;
    }

    @OutDated
    public int getWeekly_vampire_wins_a() {
        return this.weekly_vampire_wins_a;
    }

    public HashMap<HUMANPERK, Integer> getHumanPerks() {
        return this.humanPerk;
    }

    public HashMap<VAMPIREPERK, Integer> getVampirePerks() {
        return this.vampirePerk;
    }

    public ArrayList<DISGUISE> getUnlockedDisguises() {
        return this.unlockedDisguises;
    }

    public DISGUISE getSelectedDisguise() {
        return this.selectedDisguise;
    }

    public boolean isBlood() {
        return this.blood;
    }

    @OutDated
    public int getVotes_Plundered() {
        return this.votes_Plundered;
    }

    @OutDated
    public int getVotes_Church() {
        return this.votes_Church;
    }

    @OutDated
    public int getVotes_DarkValley() {
        return this.votes_DarkValley;
    }

    @OutDated
    public int getVotes_Pyramids() {
        return this.votes_Pyramids;
    }

    @OutDated
    public int getVotes_Overhill() {
        return this.votes_Overhill;
    }

    @OutDated
    public int getVotes_Erias() {
        return this.votes_Erias;
    }

    public HashMap<HUMANPERK, Integer> getHumanPerk() {
        return this.humanPerk;
    }

    public HashMap<VAMPIREPERK, Integer> getVampirePerk() {
        return this.vampirePerk;
    }
}

